package com.roco.settle.api.entity;

import java.time.LocalDateTime;

import com.roco.settle.api.enums.SettlePaymentApplyLogOperTypeEnum;
import com.roco.settle.api.request.base.FileRes;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.NoArgsConstructor;


/**
 * 业务主体支付工单文件(SettlePaymentApplyFile)实体类
 *
 * @author hsf
 * @since 2020-02-25 09:19:49
 */
@Data
@NoArgsConstructor
@Table(name = "settle_payment_apply_file")
public class SettlePaymentApplyFile implements Serializable {

    public SettlePaymentApplyFile(String applyNo, SettlePaymentApplyLogOperTypeEnum operType, String createUser,
                                  String createName, FileRes fileRes) {
        this.applyNo = applyNo;
        this.fileName = fileRes.getFileName();
        this.fileType = fileRes.getFileType();
        this.fileurl = fileRes.getFileUrl();
        this.remark = fileRes.getRemark();
        this.operType = operType;
        this.createUser = createUser;
        this.createName = createName;
        this.createTime = LocalDateTime.now();
    }

    @Id
    private Integer id;

    /**
     * settle_payment_apply.apply_no  
     */
    private String applyNo;

    /**
     * 文件类型(PDF,PNG,JPG,JPEG)  
     */
    private String fileType;

    /**
     * 路径url  
     */
    private String fileurl;

    /**
     * 附件名称  
     */
    private String fileName;

    /**
     * 附件说明  
     */
    private String remark;

    /**
     * 操作类型  
     */
    private SettlePaymentApplyLogOperTypeEnum operType;

    /**
     * 上传时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人  
     */
    private String createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

   

}