package com.roco.settle.api.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.SettlePaymentApplyLogOperTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 业务主体支付工单日志(SettlePaymentApplyLog)实体类
 *
 * @author hsf
 * @since 2020-02-25 09:19:49
 */
@Data
@Table(name = "settle_payment_apply_log")
public class SettlePaymentApplyLog implements Serializable {

   
    @Id
    private Integer id;

    /**
     * settle_payment_apply.apply_no  
     */
    private String applyNo;

    /**
     * 操作类型  
     */
    @Column(name = "operType")
    private SettlePaymentApplyLogOperTypeEnum operType;

    /**
     * 备注  
     */
    private String remark;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUser;

    private String createName;

   

}