package com.roco.settle.api.entity.enterprisetansfer;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 结算【供应商】增值服务费【虚】申请(SettleEnterpriseTransferHandleApply)实体类
 *
 * @author Andrew
 * @since 2020-02-26 17:24:26
 */
@Data
@Table(name = "settle_enterprise_transfer_handle_apply")
public class SettleEnterpriseTransferHandleApply implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 事项名称  
     */
    private String itemName;

    /**
     * 事项说明  
     */
    private String itemDesc;

    /**
     * 业务基点简称  
     */
    private String enterpriseSimpleName;

    /**
     * 业务基点编码  
     */
    private String enterpriseCode;

    /**
     * 是否人保机构  
     */
    private Long isPicc;

    /**
     * 人保机构编码  
     */
    private String piccOrgCode;

    /**
     * 对公转账申请单  
     */
    private String enterpriseTransferApplyNo;

    /**
     * 支付状态  
     */
    private String payStatus;

    /**
     * 支付单号  
     */
    private String payOrderNo;

    /**
     * 开票订单号  
     */
    private String invoiceOrderNo;

    /**
     * 开票状态  
     */
    private String invoiceStatus;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商收款账号
     */
    private String supplierAccountNo;


    /**
     * 结算金额
     */
    private BigDecimal totalSettleAmount;

    /**
     * 状态  
     */
    private String status;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    private String updateUser;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateName;

   

}