package com.roco.settle.api.entity.order;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 供应商开票订单管理(SupplierInvoiceOrder)实体类
 *
 * @author dongjuntong
 * @since 2020-02-24 10:55:53
 */
@Data
@Table(name = "supplier_invoice_order")
public class SupplierInvoiceOrder implements Serializable {

   
    @Id
    private Long id;

    /**
     * 供应商开票订单号  
     */
    private String orderCode;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;


    /**
     * 业务主体简称
     */
    private String bizSubjectCode;

    /**
     * 开票总金额  
     */
    private BigDecimal invoiceAmount;

    /**
     * 发票含税总金额  
     */
    private BigDecimal invoiceContainsTax;

    /**
     * 发票张数  
     */
    private Long invoiceCnt;

    /**
     * 结算事项类型  
     */
    private String settlementMatterType;

    /**
     * 业务主体结算事项申请单号  
     */
    private String matterCode;

    /**
     * 供应商编号  
     */
    private String supplierCode;

    /**
     * 订单状态  
     */
    private String status;

    /**
     * 创建人id  
     */
    private Long createUser;

    /**
     * 创建人名称  
     */
    private String createName;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id  
     */
    private Long updateUser;

    /**
     * 更新人名称  
     */
    private String updateName;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;


    /**
     * 确认开票时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime confirmInvoiceTime;


    /**
     * 财务收到发票时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime receiveInvoiceTime;

}