package com.roco.settle.api.entity.privatetransfer;

import lombok.Data;

import javax.persistence.Id;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/2/26 21:22</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class SettlePrivateTransferApply {
    @Id
    private Integer id;

    /**
     * 对私结算申请单号
     */
    private String transfterApplyCode;

    /**
     * 私人转账事项编码
     */
    private String privateTransfterItemCode;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    /**
     * 供应商开票订单号
     */
    private String supplierInvoiceOrderCode;

    /**
     * 业务主体支付订单号
     */
    private String bizSubjectPayOrderCode;

    /**
     * 供应商支付订单号
     */
    private String supplierPayOrderCode;

    /**
     * 对私结算申请名称
     */
    private String transferApplyName;

    /**
     * 申请单说明
     */
    private String remark;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 营业执照名称
     */
    private String licenseName;

    /**
     * 收款账户编码
     */
    private String receiveAccountCode;

    /**
     * 收款账户内型
     */
    private String accountType;

    /**
     * 收款账户开户行
     */
    private String bankName;

    /**
     * 收款账户开户支行
     */
    private String bankBranch;

    /**
     * 收款人开户名称
     */
    private String cardName;

    /**
     * 收款卡号
     */
    private String cardNo;

    /**
     * 结算总金额
     */
    private BigDecimal settleTotalAmount;

    /**
     * 结算点数
     */
    private String settlePoint;

    /**
     * 支付总金额
     */
    private String payTotalAmount;

    /**
     * 支付总笔数
     */
    private String payTotalCnt;

    /**
     * 申请单状态
     */
    private String status;

    /**
     * 创建人id
     */
    private Integer createUser;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 创建时间 
     */
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateName;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 供应商名称
     */
    private String supplierName;


}