package com.roco.settle.api.enums.enterprisetransfer;

import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EnterpriseTransferHandleOperate {

    /**
     * 提交
     */
    SUBMIT(new EnterpriseTransferHandleStatus[]{EnterpriseTransferHandleStatus.NULL,
            EnterpriseTransferHandleStatus.DRAFT},
            EnterpriseTransferHandleStatus.CONFIRMING),

    /**
     * 删除
     */
    DELETE(new EnterpriseTransferHandleStatus[]{EnterpriseTransferHandleStatus.DRAFT},
            EnterpriseTransferHandleStatus.DELETED),


    /**
     * 确认
     */
    CONFIRM(new EnterpriseTransferHandleStatus[]{EnterpriseTransferHandleStatus.CONFIRMING},
            EnterpriseTransferHandleStatus.CONFIRMED),


    /**
     * 完成
     */
    COMPLETE(new EnterpriseTransferHandleStatus[]{EnterpriseTransferHandleStatus.CONFIRMED},
            EnterpriseTransferHandleStatus.COMPLETE),

    /**
     * 取消
     */
    CANCEL(new EnterpriseTransferHandleStatus[]{
            EnterpriseTransferHandleStatus.CONFIRMING,
            EnterpriseTransferHandleStatus.CONFIRMED,
    }, EnterpriseTransferHandleStatus.CANCEL);


    @Getter
    private EnterpriseTransferHandleStatus[] before;
    @Getter
    private EnterpriseTransferHandleStatus after;


    public List<String> getBeforeList() {
        return Stream.of(before).map(EnterpriseTransferHandleStatus::name).collect(Collectors.toList());
    }

    EnterpriseTransferHandleOperate(EnterpriseTransferHandleStatus[] before, EnterpriseTransferHandleStatus after) {
        this.before = before;
        this.after = after;
    }
}
