package com.roco.settle.api.enums.enterprisetransfer;

import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EnterpriseTransferOperate {

    /**
     * 提交
     */
    SUBMIT(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.NULL,
            EnterpriseTransferStatus.DRAFT},
            EnterpriseTransferStatus.CONFIRMING),

    /**
     * 删除
     */
    DELETE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.DRAFT},
            EnterpriseTransferStatus.DELETED),


    /**
     * 确认
     */
    CONFIRM(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.CONFIRMING},
            EnterpriseTransferStatus.CONFIRMED),

    /**
     * 关联
     */
    RELATE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.CONFIRMED},
            EnterpriseTransferStatus.RELATED),

    /**
     * 完成
     */
    COMPLETE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED},
            EnterpriseTransferStatus.COMPLETE),

    /**
     * 取消
     */
    CANCEL(new EnterpriseTransferStatus[]{
            EnterpriseTransferStatus.CONFIRMING,
            EnterpriseTransferStatus.CONFIRMED,
    }, EnterpriseTransferStatus.CANCEL),

    /**
     * 关联回滚
     */
    RELATED_ROLLBACK(new EnterpriseTransferStatus[]{
            EnterpriseTransferStatus.RELATED},
            EnterpriseTransferStatus.CONFIRMED);


    @Getter
    private EnterpriseTransferStatus[] before;
    @Getter
    private EnterpriseTransferStatus after;


    public  List<String> getBeforeList() {
        return Stream.of(before).map(EnterpriseTransferStatus::name).collect(Collectors.toList());
    }

    EnterpriseTransferOperate(EnterpriseTransferStatus[] before, EnterpriseTransferStatus after) {
        this.before = before;
        this.after = after;
    }
}
