package com.roco.settle.api.request.enterprisetansfer;

import com.roco.settle.api.enums.enterprisetransfer.EnterpriseTransferOperate;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 操作请求
 *
 * @author Andrew
 * @create 2020/2/24 1:30 下午
 */
@Data
public class EnterpriseTransferOperateReq implements Serializable {

    @NotBlank
    private String applyNo;

    @NotNull
    private EnterpriseTransferOperate operate;

    /**
     * 结算订单号，   关联的时候传入
     */
    private String settleOrderNo;

    /**
     * 业务基点编码，   关联的时候传入
     */
    private String enterpriseCode;

    private String desc;

}
