package com.roco.settle.api.request.settlepaymentapply;

import com.roco.settle.api.enums.SettlePaymentApplyTypeEnum;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author hsf
 * @date 2020/02/25
 */
@Setter
@Getter
public class SettlePaymentApplySaveReq implements Serializable {
    /**
     * 创建的类型
     */
    @NotNull
    private SettlePaymentApplyTypeEnum type;
    /**
     * 业务主体code
     */
    @NotBlank
    private String bizSubjectCode;
    /**
     * 供应商code
     */
    @NotBlank
    private String supplierCode;
    /**
     * 结算工单
     */
    @NotBlank
    private String settleOrderNo;

    /**
     * 支付总金额(元)
     */
    @NotNull
    private BigDecimal amount;
}
