package com.roco.settle.api.response.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.entity.order.SupplierInvoiceOrderExpress;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import java.time.LocalDateTime;

/**
 * @author
 */
@Data
public class SupplierInvoiceOrderExpressExtResp extends SupplierInvoiceOrderExpress {

    /**
     * 发票张数
     */
    private Integer invoiceCnt;


    /**
     * 发票号码
     */
    private String invoiceCode;


    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    @Column(name = "send_time")
    private LocalDateTime sendTime;

    /**
     * 签收时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    @Column(name = "receive_time")
    private LocalDateTime receiveTime;
}
