package com.roco.settle.api.service;

import com.roco.settle.api.entity.SettleCapitalAccount;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.settlecapital.SettleCapitalAccountBatchReq;
import com.roco.settle.api.request.settlecapital.SettleCapitalAccountPageReq;
import com.roco.settle.api.request.settlecapital.SettleCapitalAccountReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.settlecapital.SettleCapitalAccountDetailResp;

import java.util.List;

/**
 * 结算业务资金账户
 * @author zhanghongshan
 */
public interface SettleCapitalAccountService {


    /**
     * 创建资金账户
     * @param request
     * @return
     */
    CommonResponse<Boolean> saveSettleCapitalAccount(CommonRequest<SettleCapitalAccountReq> request);


    /**
     * 分页查询资金账户
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SettleCapitalAccount> pageSettleCapitalAccount(CommonQueryPageRequest<SettleCapitalAccountPageReq> pageRequest);


    /**
     * 更新状态
     * @param updateRequest
     * @return
     */
    CommonResponse<Boolean> updateStatusSettleCapitalAccount(CommonRequest<SettleCapitalAccountReq> updateRequest);

    /**
     * 批量开户
     * @param batchRequest
     * @return
     */
    CommonResponse<List<SettleCapitalAccount>> batchCreateCapitalAccount(CommonRequest<SettleCapitalAccountBatchReq> batchRequest)throws Exception;

    /**
     * 资金账户查询详情
     * @param request
     * @return
     */
    CommonResponse<SettleCapitalAccountDetailResp> detailCapitalAccount(CommonRequest<SettleCapitalAccountReq> request);
}
