package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.ReceiptAccount;
import com.roco.settle.api.entity.supplier.SupplierContacts;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.supplier.catalog.CatalogPageReq;
import com.roco.settle.api.request.supplier.supplychain.ReceiptAccountPageReq;
import com.roco.settle.api.request.supplier.supplychain.ReceiptAccountReq;
import com.roco.settle.api.request.supplier.supplychain.ReceiptAccountSaveReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

/**
 * @author lanqian
 */
public interface ReceiptAccountService {

    /**
     * 查询单条记录
     * @param request
     * @return
     */
    CommonResponse<ReceiptAccount> get(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 保存
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<ReceiptAccountSaveReq> request);
    /**
     * 更新
     * @param request
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<ReceiptAccountSaveReq>request);
    /**
     * 删除
     * @param request
     * @return
     */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest>  request);
    /**
     * 根据供应商receiptAccountNo
     * 是否默认 isDefault
     * 获取供应商所有账户信息
     * @param request
     * @return
     * */
    CommonQueryPageResponse<ReceiptAccount> search(CommonQueryPageRequest<ReceiptAccountPageReq> request);

    /**
     * 根据供应商receiptAccountNo
     * 是否默认 isDefault
     * 获取供应商所有账户信息
     * @param request
     * @return
     * */
    CommonResponse<List<ReceiptAccount>> all(CommonRequest<ReceiptAccountReq> request);

    /**
     * 根据供应商supplierNo
     * 获取供应商默认的收款账户信息
     * @param request
     * @return
     * */
    CommonResponse<ReceiptAccount> getDefault(CommonRequest<ReceiptAccountReq> request);

}
