package com.roco.settle.api.enums.invoice;

import lombok.Getter;

/**
 * 发票性质枚举类
 * @author dongjuntong
 */
public enum InvoiceNatureEnum {
    /**
     * 北京大诚->业务基点
     */
    BJROCO_BASE_POINT("0","北京大诚->业务基点"),

    /**
     * 广州大诚->业务基点
     */
    GZROCO_BASE_POINT("1","广州大诚->业务基点"),

    /**
     * 供应商->北京大城
     */
    SUPPLIER_BJROCO("2","供应商->北京大诚"),

    /**
     * 供应商->北京大城
     */
    SUPPLIER_GZROCO("3","供应商->广州大诚");


    @Getter
    private String label;

    @Getter
    private String code;

    InvoiceNatureEnum(String code,String label){
        this.code=code;
        this.label=label;
    }
}
