package com.roco.settle.api.service;

import com.roco.settle.api.entity.SettleEnterpriseServiceApplyItem;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.settleserviceapplyitem.SettleEnterpriseServiceApplyItemReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.settleserviceapplydetail.SettleEnterpriseServiceApplyItemCollectResp;

import java.util.Map;

public interface SettleEnterpriseServiceApplyItemService {

    /**
     * 分页查询业务基点服务清单明细
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseServiceApplyItem> pageSettleEnterpriseServiceApplyDetail(CommonQueryPageRequest<SettleEnterpriseServiceApplyItemReq> pageRequest);

    /**
     * 批量保存清单明细
     * @param request
     * @return
     */
    CommonResponse<Boolean> batchSave(CommonRequest<SettleEnterpriseServiceApplyItemReq> request);

    /**
     * 更新服务清单名细状态
     * @param request
     * @return
     */
    CommonResponse<Map<Integer,String>> updateStatus(CommonRequest<SettleEnterpriseServiceApplyItemReq> request);

    /**
     * 统计传入清单的总笔数和总金额
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseServiceApplyItemCollectResp> collectServiceItem(CommonRequest<SettleEnterpriseServiceApplyItemReq> request);

    /**
     * 占用服务清单
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseServiceApplyItemCollectResp> allocateServiceItem(CommonRequest<SettleEnterpriseServiceApplyItemReq> request);

    /**
     * 使用服务清单
     * @param request
     * @return
     */
    CommonResponse<Boolean> usedServiceItem(CommonRequest<SettleEnterpriseServiceApplyItemReq> request);

    /**
     * 取消使用服务清单
     * @param request
     * @return
     */
    CommonResponse<Boolean> cancelServiceItem(CommonRequest<SettleEnterpriseServiceApplyItemReq> request);
}
