package com.roco.settle.api.service.enterprisesettle;


import com.roco.settle.api.entity.enterprisesettle.SettleEnterprisePrivateTransferApply;
import com.roco.settle.api.entity.enterprisesettle.SettleEnterprisePrivateTransferApplyLog;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.enterprisesettle.EnterprisePrivateTransferApplyOperateReq;
import com.roco.settle.api.request.enterprisesettle.EnterprisePrivateTransferApplyQueryReq;
import com.roco.settle.api.request.enterprisesettle.EnterprisePrivateTransferPostApplyReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * 业务基点-> 结算对私转账 申请 dubbo 服务
 * @author zhangmin
 * @create 2020/3/2 1:39 下午
 */
public interface SettleEnterprisePrivateTransferApplyService {

    /**
     * 分页查询 申请单列表
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterprisePrivateTransferApply> searchPage(CommonQueryPageRequest<EnterprisePrivateTransferApplyQueryReq> request);

    /**
     * 新增/修改 结算申请
     */
    CommonResponse<String> saveUpdateApply(CommonRequest<EnterprisePrivateTransferPostApplyReq> request);

    /**
     * 操作申请单
     * @param request
     * @return
     */
    CommonResponse<Boolean> operate(CommonRequest<EnterprisePrivateTransferApplyOperateReq> request);

    /**
     * 获得申请详情
     * @param request
     * @return
     */
    CommonResponse<SettleEnterprisePrivateTransferApply> getDetailByApplyNo(CommonRequest<EnterprisePrivateTransferApplyQueryReq> request);

    CommonQueryPageResponse<SettleEnterprisePrivateTransferApplyLog> findLogPageByApplyNo(CommonQueryPageRequest<EnterprisePrivateTransferApplyQueryReq> request);

}
