package com.roco.settle.api.enums;

public enum SupplierStatus {
    /**
     * 停用
     */
    STOP_USING("停用"),

    /**
     * 启用
     */
    START_USING("启用");

    private String name;

    SupplierStatus(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        if (i == null) {
            return "";
        }
        SupplierStatus[] values = SupplierStatus.values();
        return i >= 0 && i < values.length ? values[i].getName() : "" + i;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
