package com.roco.settle.api.request.enterprisetansfer;

import com.roco.settle.api.enums.SettleEnterpriseServiceItemMatterTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 文件内容上传
 *
 * @author Andrew
 * @create 2020/2/24 1:30 下午
 */
@Data
public class EnterpriseTransferApplyFileReq implements Serializable {

    private String supplierCode;

    @NotBlank
    private String fileUrl;

    @NotNull
    private SettleEnterpriseServiceItemMatterTypeEnum matterType;

    @NotBlank
    private String fileName;

    @NotEmpty(message = "服务清单不能为空")
    private List<String> itemNos;
}
