package com.roco.settle.api.service;

import com.roco.settle.api.entity.SettleEnterpriseServiceApply;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.settleserviceapply.SettleEnterpriseServiceApplyReq;
import com.roco.settle.api.request.settleserviceapply.SettleEnterpriseServiceApplySaveReq;
import com.roco.settle.api.request.settleserviceapply.SettleEnterpriseServiceApplyUnUsedByRemattanceReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

public interface SettleEnterpriseServiceApplyService {

    /**
     * 分页查询业务基点清单
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseServiceApply> pageSettleEnterpriseServiceApply(CommonQueryPageRequest<SettleEnterpriseServiceApplyReq> pageRequest);

    /**
     * 查询申请单详情
     * @param applyReq
     * @return
     */
    CommonResponse<SettleEnterpriseServiceApply> detailSettleEnterpriseServiceApply(CommonRequest<SettleEnterpriseServiceApplyReq> applyReq);

    /**
     * 保存更新服务清单申请单
     * @param request
     * @return
     */
    CommonResponse<Boolean> saveSettleEnterpriseServiceApply(CommonRequest<SettleEnterpriseServiceApplySaveReq> request);

    /**
     * 保存更新服务清单申请单
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SettleEnterpriseServiceApplyReq> request);

    /**
     * 查询业务基点清单
     * @param request
     * @return
     */
    CommonResponse<List<SettleEnterpriseServiceApply>> findAll(CommonRequest<SettleEnterpriseServiceApplyReq> request);

    /**
     * 分页查询业务基点清单-未被打款工单使用
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseServiceApply> pageUnUsedSettleEnterpriseServiceApply(CommonQueryPageRequest<SettleEnterpriseServiceApplyUnUsedByRemattanceReq> pageRequest);

    CommonResponse<Boolean> delete(CommonRequest<SettleEnterpriseServiceApplyReq> reqCommonRequest);

}
