package com.roco.settle.api.entity.order.payment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.order.payment.PaymentOrderStatusEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 供应商主体支付订单(SupplierPaymentApply)实体类
 *
 * @author dongjuntong
 * @since 2020-02-27 19:45:11
 */
@Data
@Table(name = "supplier_payment_apply")
public class SupplierPaymentApply implements Serializable {

   
    @Id
    private Long id;

    /**
     * 订单号  
     */
    private String applyNo;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 供应商简称  
     */
    private String supplierSimpleName;

    /**
     * 供应商编码  
     */
    private String supplierCode;

    /**
     * 支付总金额(元)  
     */
    private BigDecimal amount;

    /**
     * 支付笔数  
     */
    private Integer cnt;

    /**
     * 对私转账申请单号  
     */
    private String transferApplyNo;


    /**
     * 对私转账申请名称
     */
    private String  privateTransferItemName;

    /**
     * 业务主体结算事项申请单号  
     */
    private String matterNo;

    /**
     * 业务主体结算事项名称
     */

    private String transferApplyName;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     *业务基点简称
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 事项类型
     */
    private String matterType;


    /**
     * 订单状态  
     */
    private String status;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String updateUser;

    private String updateName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime finishTime;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime handleTime;


}