package com.roco.settle.api.request.remittance;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;


/**
 * 业务基点打款工单(SettleEnterpriseRemittanceRecord)请求实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:24:25
 */
@Data
public class SettleEnterpriseRemittanceRecordReceiptReq implements Serializable {
    @NotNull(message = "业务基点打款主键不可为空")
    private Long id;

    private String receiptRemark;
    /**
     * * 上传的新文件
     * */
    @NotNull(message = "收款凭证不可为空")
    private List<SettleEnterpriseRemittanceFileSaveReq> settleEnterpriseRemittanceFileSaveReqList;
    /**
     * 删除的附件id
     * */
    private List<Long> deletedFileIds;
}