package com.roco.settle.api.request.enterprisesettle;

import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 业务基点-油卡结算 编辑申请单 请求参数
 *
 * @author zhangmin
 * @create 2020/2/29 10:38 上午
 */
@Setter
@Getter
public class EnterpriseOilCardPostApplyReq implements Serializable {

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    /**
     * 业务基点简称
     */
    private String enterpriseSimpleName;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;

    /**
     * 业务基点资金账户编码
     */
    private String enterpriseCapitalAccountNo;

    /**
     * 是否人保机构
     */
    private Integer isPicc;

    /**
     * 人保机构编码
     */
    private String piccOrgCode;

    /**
     * 事项名称
     */
    @Length(max = 50, message ="事项名称不能超过50个字")
    private String itemName;

    /**
     * 事项说明
     */
    @Length(max = 500, message ="事项说明不能超过500个字")
    private String itemDesc;

    /**
     * 结算金额, 本次申请要结算的结算金额
     */
    private BigDecimal settleAmount;

    /**
     * 文件上传的时候存入redis, 临时key,
     * 提交的时候去redis 里面取
     */
    private String tempFileId;

    /**
     * 是否提交
     */
    private Boolean submit;

}
