package com.roco.settle.api.request.order.payment;

import com.roco.settle.api.enums.SettlePaymentApplyLogOperTypeEnum;
import com.roco.settle.api.enums.order.payment.PaymentOrderOperationTypeEnum;
import com.roco.settle.api.request.base.FileRes;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author djt
 */
@Data
public class SupplierPaymentApplyFileSaveReq implements Serializable {

    /**
     * 订单号
     */

    @NotBlank(message = "订单号不能为空")
    private String orderNo;


    @NotNull
    private PaymentOrderOperationTypeEnum paymentOrderOperationTypeEnum;

    /**
     * 文件
     */
    private List<FileRes> reses;
}
