package com.roco.settle.api.entity.expense;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务基点结算信息(SettleExpenseItemEnterprise)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:52:41
 */
@Data
@Table(name = "settle_expense_item_enterprise")
public class SettleExpenseItemEnterprise implements Serializable {

   
    @Id
    private Long id;

    /**
     * 业务基点结算信息编码  
     */
    private String code;

    /**
     * 费用项目编码  
     */
    private String itemCode;

    /**
     * 机构编码(业务基点)  
     */
    private String enterpriseCode;

    /**
     * 机构名称  
     */
    private String enterpriseName;

    /**
     * 机构简称（业务基点）  
     */
    private String enterpriseSimpleName;

    /**
     * 是否人保；0否、1是  
     */
    private Long isPicc;

    /**
     * 人保机构号  
     */
    private String piccOrgCode;

    /**
     * 业务基点结算价格  
     */
    private BigDecimal settlementPrice;

    /**
     * 结算价格说明  
     */
    private String priceRemark;

    /**
     * 创建时间  
     */
       @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人id  
     */
    private Long createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

    /**
     * 创建人类型  
     */
    private String createUsertype;

    /**
     * 更新时间  
     */
       @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id  
     */
    private Long updateUser;

    /**
     * 更新人姓名  
     */
    private String updateName;

    /**
     *  更新人类型  
     */
    private String updateUsertype;

   

}