package com.roco.settle.api.entity.expense;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 供应商结算信息(SettleExpenseItemSupplier)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:52:41
 */
@Data
@Table(name = "settle_expense_item_supplier")
public class SettleExpenseItemSupplier implements Serializable {

   
    @Id
    private Long id;

    /**
     * 供应商基点结算信息编码  
     */
    private String code;

    /**
     * 费用项目编码  
     */
    private String itemCode;

    /**
     *  供应商编号  
     */
    private String supplierCode;

    /**
     *  供应商名称  
     */
    private String supplierName;

    /**
     * 营业执照名称  
     */
    private String licenseName;

    /**
     * 人保车务平台门店编号  
     */
    private String shopCode;

    /**
     * 供应商结算价格  
     */
    private BigDecimal settlementPrice;

    /**
     * 结算价格说明  
     */
    private String priceRemark;

    /**
     * 发票类型   增值税专用发票：DEDICATED ，增值税普通发票：NORMAL  
     */
    private String invoiceType;

    /**
     * 税率
     */
    private BigDecimal invoiceTaxRate;

    /**
     * 创建时间  
     */
       @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人id  
     */
    private Long createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

    /**
     * 创建人类型  
     */
    private Object createUsertype;

    /**
     * 更新时间  
     */
       @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id  
     */
    private Long updateUser;

    /**
     * 更新人姓名  
     */
    private String updateName;

    /**
     *  更新人类型  
     */
    private String updateUsertype;

   

}