package com.roco.settle.api.entity.privatetransfer;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.enterprisetransfer.EnterpriseTransferStatus;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 对私转账(SettlePrivateApply)实体类
 *
 * @author hsf
 * @since 2020-02-29 10:29:51
 */
@Data
@Table(name = "settle_private_apply")
public class SettlePrivateApply implements Serializable {

    @Id
    private Long id;

    /**
     * 申请单号  
     */
    private String applyNo;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 事项名称  
     */
    private String itemName;

    /**
     * 事项说明  
     */
    private String itemDesc;

    /**
     * 业务基点简称  
     */
    private String enterpriseSimpleName;

    /**
     * 业务基点编码  
     */
    private String enterpriseCode;

    /**
     * 是否人保机构  
     */
    private Long isPicc;

    /**
     * 人保机构编码  
     */
    private String piccOrgCode;

    /**
     * 供应商编码  
     */
    @Deprecated
    private String supplierCode;

    /**
     * 供应商名称  
     */
    @Deprecated
    private String supplierName;

    /**
     * 供应商账户  
     */
    @Deprecated
    private String supplierAccountNo;

    /**
     * 对私转账申请单  
     */
    private String privateTransferApplyNo;

    /**
     * 支付状态  
     */
    private String payStatus;

    /**
     * 支付单号  
     */
    private String payOrderNo;

    /**
     * 开票订单号  
     */
    private String invoiceOrderNo;

    /**
     * 主体结算工单
     */
    private String settleOrderNo;

    /**
     * 基点结算工单
     */
    private String basePointSettleOrderNo;

    /**
     * 结算价格  
     */
    private BigDecimal totalSettleAmount;

    /**
     * 开票状态  
     */
    private String invoiceStatus;

    /**
     * 转账总金额  
     */
    private BigDecimal totalTransferAmount;

    /**
     * 转账笔数  
     */
    private Long totalQuantity;

    /**
     * 业务基点结算点数
     */
    private BigDecimal settlePoint;

    /**
     * 状态  
     */
    @Column(name = "status")
    private EnterpriseTransferStatus status;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    private String updateUser;

    private String updateName;

   

}