package com.roco.settle.api.request.remittance;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceCapitalTypeEnum;
import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceStatusEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 业务基点打款工单(SettleEnterpriseRemittanceRecord)请求实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:24:25
 */
@Data
public class SettleEnterpriseRemittanceRecordPayReq implements Serializable {
    @NotNull(message = "业务基点打款主键不可为空")
    private Long id;

    private String paymentRemark;
    /**
     * * 上传的新文件
     * */
    @NotNull(message = "支付凭证不可为空")
    private List<SettleEnterpriseRemittanceFileSaveReq> settleEnterpriseRemittanceFileSaveReqList;
    /**
     * 删除的附件id
     * */
    private List<Long> deletedFileIds;
}