package com.roco.settle.api.service.expense;

import com.roco.settle.api.entity.expense.SettleExpenseItemSupplier;
import com.roco.settle.api.entity.expense.SettleExpenseItemSupplierExt;
import com.roco.settle.api.entity.expense.SettleExpenseItemSupplierOperation;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.expense.enterprise.SettleExpenseItemEnterpriseBacthSaveReq;
import com.roco.settle.api.request.expense.supplier.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.expense.BatchErrorMsgDto;

import java.util.List;

/**
 * 供应商结算信息(SettleExpenseItemSupplier)表服务接口
 *
 * @author 兰倩
 * @since 2020-03-10 17:03:22
 */
public interface SettleExpenseItemSupplierService {

    /**
     * 通过ID查询单条数据
     *
     * @param request 主键
     * @return 实例对象
     */
    CommonResponse<SettleExpenseItemSupplier> get(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 通过code查询单条数据
     *
     * @param request 主键
     * @return 实例对象
     */
    CommonResponse<SettleExpenseItemSupplier> getByCode(CommonRequest<SettleExpenseItemSupplierReq> request);

    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> save(CommonRequest<SettleExpenseItemSupplierSaveReq> request);

    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */

    public CommonResponse<List<BatchErrorMsgDto>> batchSave(CommonRequest<SettleExpenseItemSupplierBacthSaveReq> request);

    /**
     * 更新记录
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> update(CommonRequest<SettleExpenseItemSupplierUpdateReq>request);

    /**
     * 列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<SettleExpenseItemSupplier> search(CommonQueryPageRequest<SettleExpenseItemSupplierPageReq> request);

    /**
     * 删除
     * @param request
     * @return
     * */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest>  request);

    /**
     * 操作列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<SettleExpenseItemSupplierOperation> searchOperation(CommonQueryPageRequest<SettleExpenseItemSupplierOperationPageReq> request);


    /**
     * 列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<SettleExpenseItemSupplierExt> searchExt(CommonQueryPageRequest<SettleExpenseItemSupplierPageOneReq> request);

    /**
     * 导入保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<List<BatchErrorMsgDto>> importItem(CommonRequest<SettleExpenseItemSupplierImportSaveReq> request);

}