package com.roco.order.api.enums;

import lombok.Getter;

/**
 * @author hsf
 * @date 2020-03-18 11:16
 */
@Getter
public enum QueueOrderEnum {
    ORDER_OIL_CARD("order_oil_card_direct", "order_oil_card_queue", "order_oil_card_queue"),
    ORDER_PUBLIC("order_public_direct", "order_public_queue", "order_public_queue"),
    ORDER_PRIVATE("order_private_direct", "order_private_queue", "order_private_queue"),
    ;

    /**
     * 交换名称
     */
    private String exchange;
    /**
     * 队列名称
     */
    private String name;
    /**
     * 路由键
     */
    private String routeKey;

    QueueOrderEnum(String exchange, String name, String routeKey) {
        this.exchange = exchange;
        this.name = name;
        this.routeKey = routeKey;
    }
}
