package com.roco.settle.api.entity.invoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/2/19 17:4</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name="invoice")
public class Invoice implements Serializable {

    @Id
    private Long id;

    /**
     * 入库申请单号
     */
    private String applyCode;

    /**
     * 开票主体类型 业务主体:BIZ_SUBJECT 供应商:SUPPLIER
     */
    private String invoiceSubjectType;

    /**
     * 发票性质
     */
    private String invoiceNature;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    /**
     * 业务主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 业务基点编码
     */
    private String basePointCode;

    /**
     * 业务基点简称
     */
    private String basePointSimpleName;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商名称
     */
    private String supplierSimpleName;


    /**
     * 发票号码
     */
    private String invoiceCode;

    /**
     * 发票代码
     */
    private String invoiceNo;

    /**
     * 发票类型   增值税专用发票：DEDICATED ，增值税普通发票：NORMAL
     */
    private String invoiceType;

    /**
     * 发票保存地址
     */
    private String invoiceUrl;

    /**
     * 发票金额
     */
    private BigDecimal invoiceAccount;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 税额
     */
    private BigDecimal tax;

    /**
     * 发票含税金额
     */
    private BigDecimal taxAccount;

    /**
     * 付款方
     */
    private String payer;

    /**
     * 收款方
     */
    private String payee;

    /**
     * 开票日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private String billingDate;

    /**
     * 申请状态 草稿：DRAFT 待确认: UNCONFIRMED 已入库: CONFIRMED 已作废: INVALID
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;


    /**
     * 物流编号
     */
    private String expressCode;

}