package com.roco.settle.api.entity.remittance;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceCapitalTypeEnum;
import com.roco.settle.api.enums.remittance.SettleEnterpriseRemittanceStatusEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务基点打款工单(SettleEnterpriseRemittanceRecord)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:24:25
 */
@Data
@Table(name = "settle_enterprise_remittance_record")
public class SettleEnterpriseRemittanceRecord implements Serializable {

   
    @Id
    private Long id;

    /**
     * 业务基点打款工单号  
     */
    private String code;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人id  
     */
    private Long createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

    /**
     * 创建人类型  
     */
    private Object createUsertype;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id  
     */
    private Long updateUser;

    /**
     * 更新人姓名  
     */
    private String updateName;

    /**
     *  更新人类型  
     */
    private String updateUsertype;

    /**
     * 状态  
     */
    private SettleEnterpriseRemittanceStatusEnum status;

    /**
     * 逻辑删除（0：未删除，1：已删除）  
     */
    private Integer deleted;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 机构编码(业务基点)  
     */
    private String enterpriseCode;

    /**
     * 机构简称（业务基点）  
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号  
     */
    private String piccOrgCode;
    /**是否人保机构
     * */
    private  Long isPicc;
    /**
     * 工单名称  
     */
    private String name;

    /**
     * 工单说明  
     */
    private String introduction;

    /**
     * 工单类型  
     */
    @Column(name="type")
    private String type;

    /**
     * 打款金额  
     */
    private BigDecimal remittanceAmount;

    /**
     * 资金性质  
     */
    @Column(name="capital_type")
    private SettleEnterpriseRemittanceCapitalTypeEnum capitalType;

    /**
     * 服务清单申请单编码  
     */
    private String serviceApplyCode;

    /**
     * 清单总笔数  
     */
    private Long serviceTotalCnt;

    /**
     * 清单总金额  
     */
    private BigDecimal serviceTotalAmount;

    /**
     * 业务基点提供附件日期  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate serviceProvideDate;

    /**
     * 支付确认时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime paymentTime;

    /**
     * 支付确认备注  
     */
    private String paymentRemark;

    /**
     * 收款确认时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime receiptTime;

    /**
     * 收款确认备注  
     */
    private String receiptRemark;

    /**
     * 取消时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime cancelTime;

    /**冗余信息*/
    @Transient
    private String enterpriseName;

}