package com.roco.settle.api.enums.invoice;


import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 发票操作类型枚举
 * @author dongjuntong
 */
public enum InvoiceOperationTypeEnum {

    /**
     * 创建
     */
    CREATE(new InvoiceApplyStatusEnum[]{InvoiceApplyStatusEnum.EMPTY},InvoiceApplyStatusEnum.DRAFT),


    /**
     * 提交
     */
    SUBMIT(new InvoiceApplyStatusEnum[]{InvoiceApplyStatusEnum.DRAFT},InvoiceApplyStatusEnum.UNCONFIRMED),


    /**
     * 编辑
     */
    EDIT(new InvoiceApplyStatusEnum[]{InvoiceApplyStatusEnum.DRAFT},InvoiceApplyStatusEnum.DRAFT),


    /**
     * 确认入库
     */
    CONFIRM(new InvoiceApplyStatusEnum[]{InvoiceApplyStatusEnum.UNCONFIRMED},InvoiceApplyStatusEnum.CONFIRMED),


    /**
     * 作废
     */
     INVALID(new InvoiceApplyStatusEnum[]{InvoiceApplyStatusEnum.UNCONFIRMED,InvoiceApplyStatusEnum.CONFIRMED},InvoiceApplyStatusEnum.INVALID),

    /**
     * 删除
     */
    DELETE(new InvoiceApplyStatusEnum[]{InvoiceApplyStatusEnum.DRAFT},InvoiceApplyStatusEnum.EMPTY);


    @Getter
    private InvoiceApplyStatusEnum[] before;

    @Getter
    private InvoiceApplyStatusEnum after;


    InvoiceOperationTypeEnum(InvoiceApplyStatusEnum[] before,InvoiceApplyStatusEnum after){
        this.before = before;
        this.after = after;
    }


    public List<String> getBefore(){
        return Stream.of(before).map(InvoiceApplyStatusEnum::name).collect(Collectors.toList());
    }

    public String getAfter(){
        return this.after.name();
    }


}
