package com.roco.settle.api.enums.order.payment;

import lombok.Getter;

/**
 * 供应商支付订单状态枚举类
 * @author dongjuntong
 */
public enum PaymentOrderStatusEnum {

    /***
     *空
     */
    EMPTY("空"),

    /**
     * 待处理
     */
    WAIT_HANDLE("待处理"),


    /**
     * 处理中
     */
    HANDLING("处理中"),


    /**
     * 处理完成
     */
    FINISH("处理完成"),


    /**
     * 取消
     */
    CANCEL("取消");


    @Getter
    private String label;


    PaymentOrderStatusEnum(String label){
        this.label=label;
    }
}
