package com.roco.settle.api.request.expense.supplier;

import com.roco.settle.api.entity.expense.SettleExpenseItemSupplier;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;


/**
 * 供应商结算信息(SettleExpenseItemSupplier)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:52:41
 */
@Data
public class SettleExpenseItemSupplierPageReq implements Serializable {
    /**
     *  供应商编号
     */
    private String supplierCode;
    /**
     * 费用项目编码
     */
    @NotBlank(message = "项目编码不可为空")
    private String itemCode;
}