package com.roco.settle.api.entity.order.payment;

import java.time.LocalDateTime;

import com.roco.settle.api.enums.order.payment.PaymentOrderOperationTypeEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 供应商支付订单日志(SupplierPaymentApplyLog)实体类
 *
 * @author dongjuntong
 * @since 2020-02-27 19:46:20
 */
@Data
@Table(name = "supplier_payment_apply_log")
public class SupplierPaymentApplyLog implements Serializable {

   
    @Id
    private Long id;

    /**
     * 订单号  
     */
    private String orderNo;

    /**
     * 操作类型  
     */
    private String operType;

    /**
     * 备注  
     */
    private String remark;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUser;

    private String createName;

   

}