package com.roco.settle.api.request.invoice;

import com.roco.settle.api.enums.invoice.InvoiceApplyStatusEnum;
import com.roco.settle.api.enums.invoice.InvoiceNatureEnum;
import com.roco.settle.api.enums.invoice.InvoiceSubjectTypeEnum;
import com.roco.settle.api.enums.invoice.InvoiceTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 发票分页查询
 * @author dongjuntong
 */
@Data
public class InvoicePageReq implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     *订单号
     */
    private String orderCode;

    /**
     * 入库申请单号
     */
    private String applyCode;

    /**
     * 发票性质
     */
    private String invoiceNature;


    /**
     * 业务基点编码
     */
    private String basePointCode;

    /**
     * 供应商编码
     */
    private String supplierCode;


    /**
     * 开票主体类型 业务主体:BIZ_SUBJECT 供应商:SUPPLIER
     */
    private String invoiceSubjectType;


    /**
     * 发票号码
     */
    private String invoiceCode;


    /**
     * 发票代码
     */
    private String invoiceNo;


    /**
     * 发票类型   增值税专用发票：DEDICATED ，增值税普通发票：NORMAL
     */
    private String invoiceType;


    /**
     * 业务主体编码
     */
    private String bizSubjectCode;


    /**
     * 申请状态 草稿：DRAFT 待确认: UNCONFIRMED 已入库: CONFIRMED 已作废: INVALID
     */
    private String status;

}
