package com.roco.settle.api.request.invoice;

import com.roco.settle.api.enums.invoice.InvoiceOperationTypeEnum;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * @author dongjuntong
 * @create 2020/2/6 15:35
 */
@Data
public class InvoiceUpdateStatusReq implements Serializable {
    /**
     * 发票id
     */
    @NotNull(message ="发票id不能为空" )
    private Long id;

    /**
     * 发票入库申请单号
     */
    @NotNull(message = "发票code不能为空")
    private String Code;
    /**
     * 发票状态
     */
    @NotNull(message = "操作类型不能为空")
    private InvoiceOperationTypeEnum operationType;

}
