package com.roco.settle.api.request.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 供应商开票订单-寄送信息(SupplierInvoiceOrderExpress)更新
 *
 * @author dongjuntong
 * @since 2020-02-26 13:50:35
 */
@Data
public class SupplierInvoiceOrderExpressUpdateReq implements Serializable {


    /**
     * 寄送信息编号
     */
    private String  code;


    /**
     * 开票订单号  
     */
    private String orderCode;


    /**
     * 寄送信息包括的发票编码
     */
    @NotEmpty(message = "请选择发票后再保存")
    private List<String>  expressInvoices;

    /**
     * 寄送类型  
     */
    private String type;

    /**
     * 快递公司  
     */
    private String expressCompany;

    /**
     * 快递单号  
     */
    private String expressNumber;

    /**
     * 寄送负责人
     */
    private String courier;

    /**
     * 寄送时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime sendTime;

    /**
     * 签收时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime receiveTime;

    /**
     * 签收人  
     */
    private String receiveUser;

    /**
     * 快递单截图  
     */
    private String expressImage;

    /**
     * 签收凭证  
     */
    private String receiveImage;

    /**
     * 备注  
     */
    private String remark;


}