package com.roco.settle.api.service.expense;


import com.roco.settle.api.entity.expense.SettleExpenseItem;
import com.roco.settle.api.entity.expense.SettleExpenseItemEnterprise;
import com.roco.settle.api.entity.expense.SettleExpenseItemEnterpriseExt;
import com.roco.settle.api.entity.expense.SettleExpenseItemEnterpriseOperation;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.expense.enterprise.*;
import com.roco.settle.api.request.expense.supplier.SettleExpenseItemSupplierImportSaveReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.expense.BatchErrorMsgDto;

import java.util.List;

/**
 * 业务基点结算信息(SettleExpenseItemEnterprise)表服务接口
 *
 * @author 兰倩
 * @since 2020-03-10 17:03:22
 */
public interface SettleExpenseItemEnterpriseService {

    /**
     * 通过ID查询单条数据
     *
     * @param request 主键
     * @return 实例对象
     */
    CommonResponse<SettleExpenseItemEnterprise> get(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 通过code查询单条数据
     *
     * @param request 主键
     * @return 实例对象
     */
    CommonResponse<SettleExpenseItemEnterprise> getByCode(CommonRequest<SettleExpenseItemEnterpriseReq> request);

    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> save(CommonRequest<SettleExpenseItemEnterpriseSaveReq> request);
    /**
     * 新增保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<List<BatchErrorMsgDto>> batchSave(CommonRequest<SettleExpenseItemEnterpriseBacthSaveReq> request);

    /**
     * 更新记录
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> update(CommonRequest<SettleExpenseItemEnterpriseUpdateReq>request);

    /**
     * 列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<SettleExpenseItemEnterprise> search(CommonQueryPageRequest<SettleExpenseItemEnterprisePageReq> request);

    /**
     * 删除
     * 参数 id
     * */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest>  request);
    /**
     * 列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<SettleExpenseItemEnterpriseOperation> searchOperation(CommonQueryPageRequest<SettleExpenseItemEnterpriseOperationPageReq> request);


    /**
     * 列表-分页
     * @param request 关键字
     * @return
     */
    CommonQueryPageResponse<SettleExpenseItemEnterpriseExt> searchExt(CommonQueryPageRequest<SettleExpenseItemEnterprisePageOneReq> request);

    /**
     * 列表-分页
     * @param request 关键字
     * @return
     */
    CommonResponse<List<SettleExpenseItemEnterpriseExt>> export(CommonRequest<SettleExpenseItemEnterprisePageOneReq> request);

    /**
     * 导入保存
     * @param request
     * @return 保存结果
     * */
    CommonResponse<List<BatchErrorMsgDto>> importItem(CommonRequest<SettleExpenseItemEnterpriseImportSaveReq> request);

    /**
     * 单个上架
     */
    CommonResponse<Boolean> upper(CommonRequest<SettleExpenseItemEnterpriseOnlineReq> request);

    /**
     * 批量上架
     */
    CommonResponse<Integer> upperBacth(CommonRequest<SettleExpenseItemEnterpriseBatchOnlineReq> request);

    /**
     * 下架
     */
    CommonResponse<Boolean> lower(CommonRequest<SettleExpenseItemEnterpriseOnlineReq> request);

    /**
     * 批量下架
     */
    CommonResponse<Integer> lowerBatch(CommonRequest<SettleExpenseItemEnterpriseBatchOnlineReq> request);


}