package com.roco.settle.api.util;


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtil {
    /**
     * 定义常量
     **/
    public static final String YYYY_MM = "yyyyMM";
    public static final String YYYY__MM = "yyyy-MM";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String DATE_KEY_STR = "yyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String START_TIME = " 00:00:00";//开始时间
    public static final String END_TIME = " 23:59:59"; //结束时间

    /**
     * 使用预设格式提取字符串日期
     *
     * @param strDate 日期字符串
     * @return
     */
    public static Date parseToDateTime(String strDate) {
        return parse(strDate, YYYY_MM_DD_HH_MM_SS);
    }

    /**
     * 使用预设格式提取字符串日期
     *
     * @param strDate 日期字符串
     * @return
     */
    public static Date parseToDate(String strDate) {
        return parse(strDate, YYYY_MM_DD);
    }

    /**
     * 使用用户格式提取字符串日期
     *
     * @param strDate 日期字符串
     * @param pattern 日期格式
     * @return
     */
    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 比较指定时间与当前时间的大小
     *
     * @param date 指定时间
     * @return 指定时间大于当前时间返回正数 相等返回0  小于返回负数
     */
    public static int compareDateWithNow(Date date) {
        return compareDate(date, new Date());
    }

    /**
     * 两个date类型比较
     *
     * @param date1 date1
     * @param date2 date2
     * @return date1大于date2返回正数，等于返回0 ，小于返回负数
     */
    public static int compareDate(Date date1, Date date2) {
        int rnum = date1.compareTo(date2);
        return rnum;
    }

    /**
     * 将指定的日期转换成Unix时间戳
     *
     * @param date 需要转换的日期 yyyy-MM-dd HH:mm:ss
     * @return long 时间戳
     */
    public static long format(String date) {
      return format(date,YYYY_MM_DD_HH_MM_SS);
    }

    /**
     * 将指定的日期转换成Unix时间戳
     *
     * @param date    需要转换的日期字符串
     * @param pattern 传入的指定日期字符串的格式
     * @return long 时间戳
     */
    public static long format(String date, String pattern) {
        long timestamp = 0;
        try {
            timestamp = new SimpleDateFormat(pattern).parse(date).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    /**
     * 将指定的日期转换成指定格式的时间字符串
     *
     * @param date    需要转换的日期
     * @param pattern 指定日期字符串格式
     * @return String 时间戳
     */
    public static String format(Date date, String pattern) {
        String timestamp = "0";
        try {
            timestamp = new SimpleDateFormat(pattern).format(date);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    /**
     * 将当前日期转换成Unix时间戳
     *
     * @return long 时间戳
     */
    public static long dateToUnixTimestamp() {
        long timestamp = System.currentTimeMillis();
        return timestamp;
    }

    /**
     * 根据字符串格式,日期字符串
     *
     * @param formatStr 格式化参数
     * @param dateStr   日期
     * @return
     */
    public static String formatDate(String dateStr, String formatStr) {
        return new SimpleDateFormat(formatStr).format(parseToDate(dateStr));
    }

    public static LocalDateTime formatDateStrToLocalDateTime(String dateStr){
        DateTimeFormatter df = DateTimeFormatter.ofPattern(DateUtil.YYYY_MM_DD_HH_MM_SS);
        return LocalDateTime.parse(dateStr, df);
    }

    /**
     * 字符串 -> LocalDate
     *
     * @param s Date
     * @return
     */
    public static LocalDate parseToLocalDate(String s) {
        if (s == null) {
            return null;
        }
        return LocalDate.parse(s, DateTimeFormatter.ofPattern(YYYY_MM_DD));
    }


    public static String getProbablyTimeCN(Integer seconds) {
        StringBuilder result = new StringBuilder();
        try {
            if (seconds == null && seconds < 0) {
                return null;
            }
            //小时
            int h = seconds / 3600;
            //分钟
            int m = (seconds % 3600) / 60;
            //秒钟
            int s = (seconds % 3600) % 60;
            if (h > 0) {
                result.append(h).append("小时");
            }
            if (m > 0) {
                result.append(m).append("分钟");
            }
            if (h == 0 && m == 0 && s > 0) {
                result.append(s).append("秒");
            }
            return result.toString();
        } catch (Exception e) {
            return result.toString();
        }
    }
}