package com.roco.settle.api.entity.billing;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.entity.invoice.Invoice;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 业务主体开票工单-发票关联(SettleSubjectBillingReferenceInvoice)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:41:44
 */
@Data
public class SettleSubjectBillingReferenceInvoiceExt extends Invoice implements Serializable{

    private Long billingReferenceInvoiceId;

    /**
     * 开票工单号
     */
    private String billingCode;

    /**
     * 添加时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime addTime;
    /**寄送编码
     * */
    private  String sendCode;


}