package com.roco.settle.api.entity.supplier;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.product.ProductNature;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Andrew
 * @create 2020/2/19 10:56 上午
 */

@Data
@Table(name = "product")
public class Product implements Serializable {

    @Id
    private Long id;

    /**
     * 编码
     */
    private String code;
    /**
     * 名称
     */
    private String name;
    /**
     * 拼音
     */
    private String pinyin;
    /**
     * 简称
     */
    private String simpleName;
    /**
     * 供应商编号
     */
    private String supplierNo;
    /**
     * 类目编码
     */
    private String catalogCode;
    /**
     * 品牌编码
     */
    private String brandCode;
    /**
     * 面值
     */
    private BigDecimal price;
    /**
     * 充值折扣
     */
    private BigDecimal discount;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;
    /**
     * 说明
     */
    private String remark;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUsertype;

    private String updateUser;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    private String updateUsertype;

    private String updateName;

    /**
     * 上游商品编号
     */
    private String  upstreamCode;

    @Column(name = "nature")
    private ProductNature nature;

    /**
     * 商品摘要
     */
    private String productBrief;


    /**
     * 供应商渠道名称
     */
    private String channelName;


    /**
     * 供应商渠道编号
     */
    private String channelCode;

}
