package com.roco.settle.api.entity.supplier;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.IsEnum;
import com.roco.settle.api.enums.ReceiptAccountTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author lq
 * @create 2020/2/19 11:02 上午
 */
@Data
@Table(name = "sc_receipt_account")
public class ReceiptAccount implements Serializable {
    @Id
    private Long id;

    /**
     *  收款账户编号
     */
    private String accountNo;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 账户类型，对公 PUBLIC 对私 PRIVATE
     */
    @Column(name = "type")
    private ReceiptAccountTypeEnum type;

    /**
     * 开户银行
     */
    private String bank;

    /**
     * 开户名称
     */
    private String name;

    /**
     * 开户支行
     */
    private String subbranch;

    /**
     * 开户账号
     */
    private String account;

    /**
     * 开户电话
     */
    private String mobile;

    /**
     * 开户地址
     */
    private String address;

    /**
     * 是否默认收款账户
     */
    private IsEnum isDefault;

    /**
     *  供应商编号
     */
    private String supplierNo;
    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
    /**
     * 更新人类型
     * */

    private String updateUsertype;
    /**
     * 更新日期
     * */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

}