package com.roco.settle.api.entity.supplier;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/8 18:7</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Table(name="sc_supplier_channel")
@Data
public class SupplierChannel implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 渠道编号
     */
    private String code;

    /**
     * 供应商编号
     */
    private String supplierCode;

    /**
     *  渠道名称
     */
    private String channelName;

    /**
     * 渠道摘要
     */
    private String channelBrief;

    /**
     *  备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     *  
     */
    private String createName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private Long updateUser;

    /**
     *  
     */
    private String updateName;


}