package com.roco.settle.api.request.supplier.catalog;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author Andrew
 * @create 2020/2/19 11:14 上午
 */
@Data
public class CatalogUpdateStatusReq implements Serializable {
	/**
	 * 分类ID
	 */
    @NotNull(message = "分类主键不可为空")
    @Min(1)
	private Long productCatalogId;

	/**
	 * 状态(1启用,0停用)
	 */
    @NotNull(message = "状态不可为空")
    @Min(0)
    @Max(1)
	private Integer status;

}
