package com.roco.settle.api.enums.enterprisesettle;

import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 业务基点 油卡结算申请 操作枚举
 * @author zhangmin
 */
public enum EnterpriseOilCardApplyOperate {

    /**
     * 提交
     */
    SUBMIT(new EnterpriseOilCardApplyStatus[]{EnterpriseOilCardApplyStatus.NULL,
            EnterpriseOilCardApplyStatus.DRAFT},
            EnterpriseOilCardApplyStatus.PENDING),

    /**
     * 删除
     */
    DELETE(new EnterpriseOilCardApplyStatus[]{EnterpriseOilCardApplyStatus.DRAFT},
            EnterpriseOilCardApplyStatus.DELETED),


    /**
     * 处理
     */
    COMPLETE(new EnterpriseOilCardApplyStatus[]{EnterpriseOilCardApplyStatus.PENDING},
            EnterpriseOilCardApplyStatus.COMPLETE),

    /**
     * 取消
     */
    CANCEL(new EnterpriseOilCardApplyStatus[]{
            EnterpriseOilCardApplyStatus.PENDING,
    }, EnterpriseOilCardApplyStatus.CANCEL);


    @Getter
    private EnterpriseOilCardApplyStatus[] before;
    @Getter
    private EnterpriseOilCardApplyStatus after;


    public List<String> getBeforeList() {
        return Stream.of(before).map(EnterpriseOilCardApplyStatus::name).collect(Collectors.toList());
    }

    EnterpriseOilCardApplyOperate(EnterpriseOilCardApplyStatus[] before, EnterpriseOilCardApplyStatus after) {
        this.before = before;
        this.after = after;
    }
}
