package com.roco.settle.api.response.base;

import com.roco.settle.api.enums.ResponseEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author Andrew
 * @create 2020/2/4 8:58 下午
 */
@Setter
@Getter
@ToString
public class CommonQueryPageResponse<T> implements Serializable {
    private List<T> result;

    private long total;

    private int pages;

    private String code;

    private String message;

    public boolean isSuccess() {
        return ResponseEnum.isSuccess(code);
    }

    private static CommonQueryPageResponse getResponse(ResponseEnum responseCode) {
        CommonQueryPageResponse response = new CommonQueryPageResponse();
        response.setCode(responseCode.getCode());
        response.setMessage(responseCode.getMessage());
        return response;
    }

    public static CommonQueryPageResponse success(List result, long total, int pages) {
        CommonQueryPageResponse response = getResponse(ResponseEnum.SUCCESS);
        response.setTotal(total);
        response.setPages(pages);
        response.setResult(result);
        return response ;
    }
}
