package com.roco.settle.api.entity.billing;

import java.time.LocalDateTime;

import com.roco.settle.api.enums.billing.SettleSubjectBillingSendTypeEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 业务主体开票工单-寄送信息(SettleSubjectBillingSend)实体类
 *
 * @author 兰倩
 * @since 2020-02-25 17:27:41
 */
@Data
@Table(name = "settle_subject_billing_send")
public class SettleSubjectBillingSend implements Serializable {

   
    @Id
    private Long id;

    /**
     * 寄送信息编码  
     */
    private String code;

    /**
     * 开票工单号  
     */
    private String billingCode;

    /**
     * 寄送类型  
     */
    @Column(name="type")
    private SettleSubjectBillingSendTypeEnum type;

    /**
     * 快递公司  
     */
    private String expressCompany;

    /**
     * 快递单号  
     */
    private String expressNumber;

    /**
     * 寄送时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime sendTime;

    /**
     * 签收时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime receiveTime;

    /**
     * 寄送负责人  
     */
    private String courier;

    /**
     * 快递单截图  
     */
    private String expressImage;

    /**
     * 签收凭证  
     */
    private String receiveImage;

    /**
     * 备注  
     */
    private String remark;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人id  
     */
    private Long createUser;

    /**
     * 创建人姓名  
     */
    private String createName;

    /**
     * 创建人类型  
     */
    private String createUsertype;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id  
     */
    private Long updateUser;

    /**
     * 更新人姓名  
     */
    private String updateName;

    /**
     *  更新人类型  
     */
    private String updateUsertype;

   

}