package com.roco.settle.api.request.invoice;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.invoice.InvoiceOperationTypeEnum;
import com.roco.settle.api.request.base.FileRes;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * @author dongjuntong
 * @create 2020/2/6 15:35
 */
@Data
public class InvoiceUpdateStatusReq implements Serializable {
    /**
     * 发票id
     */
    private Long id;

    /**
     * 发票入库申请单号
     */
    @NotNull(message = "发票code不能为空")
    private String Code;
    /**
     * 发票状态
     */
    @NotNull(message = "操作类型不能为空")
    private InvoiceOperationTypeEnum operationType;


    /**
     * 发票真实作废日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate invalidDate;

    /**
     * 发票文件
     */
    private List<FileRes> reses;


    /**
     * 备注
     */
    private String remark;
}
