package com.roco.settle.api.service.billing;

import com.roco.settle.api.entity.billing.*;
import com.roco.settle.api.entity.invoice.Invoice;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.billing.*;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.billing.SettleSubjectBillingRecordRes;
import com.roco.settle.api.response.billing.SettleSubjectBillingReferenceInvoiceRes;

import java.util.List;

/**
 * 业务主体开票工单(SettleSubjectBillingRecord)表服务接口
 *
 * @author 兰倩
 * @since 2020-02-25 18:02:19
 */
public interface SettleSubjectBillingRecordService {
    /**
     * 查询单条记录
     * @param  request
     * @return SettleSubjectBillingRecordService
     */
    CommonResponse<SettleSubjectBillingRecordRes> get(CommonRequest<SettleSubjectBillingRecordReq> request);
    /**
     * 添加发票
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> addInvoice(CommonRequest<SettleSubjectBillingReferenceInvoiceSaveReq> request);
    /**
     * 删除发票
     * @param request
     * @return
     * */
    CommonResponse<Boolean> delInvoice(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 获取关联的发票信息
     * @param request
     * @return
     * */
    CommonResponse<SettleSubjectBillingReferenceInvoiceRes> getReferenceInvoice(CommonRequest<SettleSubjectBillingRecordReq> request);
    /**
     * 获取开票工单可以使用的发票
     * @param request
     * @return List<Invoice>
     * */
    CommonResponse<List<Invoice>> getInvoiceForReference(CommonRequest<BasePrimaryKeyRequest> request);

    /**
     * 确认已开票
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> invoiced(CommonRequest<BasePrimaryKeyRequest>request);
    /**
     * 添加寄送信息
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> addSend(CommonRequest<SettleSubjectBillingSendSaveReq> request);
    /**
     * 编辑寄送信息
     * @param request
     * @return 保存结果
     * */
    CommonResponse<Boolean> editSend(CommonRequest<SettleSubjectBillingSendUpdateReq> request);
    /**
     * 删除发票寄送信息
     * @param request
     * @return
     * */
    CommonResponse<Boolean> delSend(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 查询所有寄送信息
     * */
    CommonResponse< List<SettleSubjectBillingSendExt>> getAllSend(CommonRequest<SettleSubjectBillingSendReq> request);
    /**
     * 获取关联的寄送信息
     * @param request
     * @return
     * */
    CommonResponse<SettleSubjectBillingSend> getSend(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 为寄送信息查询发票
     * */
    CommonResponse<List<SettleSubjectBillingReferenceInvoiceExt> > getInvoiceForSend(CommonRequest<SettleSubjectBillingSendReq> request);
    /**
     * 确认已寄送
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> sent(CommonRequest<BasePrimaryKeyRequest>request);
    /**
     * 确认客户收到票
     * @param request
     * @return 更新结果
     * */
    CommonResponse<Boolean> singed(CommonRequest<BasePrimaryKeyRequest>request);

    /**
     * 商品分类列表-分页
     * @param request 关键字
     * @return 分页查询实体
     */
    CommonQueryPageResponse<SettleSubjectBillingRecord> search(CommonQueryPageRequest<SettleSubjectBillingRecordPageReq> request);

    /**
     * 获取没被使用过的发票
     * */
    CommonQueryPageResponse<Invoice> queryNoUsedInvoiceForBillingPage (CommonQueryPageRequest<QueryNoUsedInvoiceForBillingPageReq> request);

/*
    */
/**
     * 查询全部商品分类
     * @param request
     * @return 查询实体
     *//*

    CommonResponse<List<SettleSubjectBillingRecord>> all(CommonRequest<SettleSubjectBillingRecordReq> request);

*/
/**
 *开票的操作记录
 */
CommonQueryPageResponse<SettleSubjectBillingOperation> searchOperation(CommonQueryPageRequest<SettleSubjectBillingOperationPageReq> request);


}