package com.roco.settle.api.service.order;

import com.roco.settle.api.entity.invoice.Invoice;
import com.roco.settle.api.entity.order.SupplierInvoiceOrder;
import com.roco.settle.api.entity.order.SupplierInvoiceOrderExt;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.order.SupplierInvoiceOrderCodeReq;
import com.roco.settle.api.request.order.SupplierInvoiceOrderPageReq;
import com.roco.settle.api.request.order.SupplierInvoiceOrderUpdateStatusReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

import java.util.List;

/**
 * 供应商开票订单管理
 * @author dongjuntong
 */
public interface SupplierInvoiceOrderService {

    /**
     * 分页查询供应商开票订单
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SupplierInvoiceOrder> page(CommonQueryPageRequest<SupplierInvoiceOrderPageReq> pageRequest);


    /**
     * 更新供应商开票订单状态
     * @param updateRequest
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SupplierInvoiceOrderUpdateStatusReq> updateRequest);


    /**
     * 查询供应商开票订单详情包括事项信息
     * @param request
     * @return
     */
    CommonResponse<SupplierInvoiceOrderExt> detail(CommonRequest<BasePrimaryKeyRequest> request);


    /**
     * 查询供应商开票订单详情
     * @param request
     * @return
     */
    CommonResponse<SupplierInvoiceOrder> detailByCode(CommonRequest<SupplierInvoiceOrderCodeReq> request);

    /**
     * 不分页查询订单发票
     * @param pageRequest
     * @return
     */
    CommonResponse<List<Invoice>> selectInvoices(CommonRequest<SupplierInvoiceOrderPageReq> pageRequest);
}
